
' data struct.
Type TFeature

	Field Position:Vector2 = Vector2.Zero() 
	Field Normal:Vector2 = Vector2.Zero() 
	Field Distance:Float

	Function Create:TFeature(pos:Vector2) 
		Local feature:TFeature = New TFeature
		feature.Position.X = pos.X
		feature.Position.Y = pos.Y				 
		feature.Distance = MathHelper.MaxValueF
		Return feature
	End Function
	
	Function Create2:TFeature(pos:Vector2, norm:Vector2, dist:Float) 
		Local feature:TFeature = New TFeature
		feature.Normal.X = norm.X
		feature.Normal.Y = norm.Y
		feature.Position.X = pos.X
		feature.Position.Y = pos.Y		
		feature.Distance = dist
		Return feature
	End Function
	
	Method Reset()
		Position.X = 0
		Position.Y = 0
		Normal.X = 0
		Normal.Y = 0
		Distance = 0
	End Method
	
	Method Init(pos:Vector2, norm:Vector2, dist:Float)
		Normal.X = norm.X
		Normal.Y = norm.Y
		Position.X = pos.X
		Position.Y = pos.Y
		Distance = dist
	End Method
End Type
